/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.torocraft.torohealth.bars.HealthBarRenderer;

public class BarDisplay {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft mc;
    private final Screen gui;

    public BarDisplay(Minecraft mc, Screen gui) {
        this.mc = mc;
        this.gui = gui;
    }

    private String getEntityName(LivingEntity entity) {
        return entity.m_5446_().getString();
    }

    public void draw(GuiGraphics guiGraphics, LivingEntity entity) {
        int xOffset = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_TEXTURES);
        RenderSystem.enableBlend();
        HealthBarRenderer.render(guiGraphics.m_280168_(), entity, (MultiBufferSource)guiGraphics.m_280091_(), 63.0, 14.0, 130.0f, false);
        String name = this.getEntityName(entity);
        int healthMax = Mth.m_14167_((float)entity.m_21233_());
        int healthCur = Math.min(Mth.m_14167_((float)entity.m_21223_()), healthMax);
        String healthText = healthCur + "/" + healthMax;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280488_(this.mc.f_91062_, name, xOffset, 2, 0xFFFFFF);
        guiGraphics.m_280488_(this.mc.f_91062_, name, xOffset, 2, 0xFFFFFF);
        this.renderHeartIcon(guiGraphics, xOffset += this.mc.f_91062_.m_92895_(name) + 5, 1);
        guiGraphics.m_280488_(this.mc.f_91062_, healthText, xOffset += 10, 2, 0xE0E0E0);
        xOffset += this.mc.f_91062_.m_92895_(healthText) + 5;
        int armor = entity.m_21230_();
        if (armor > 0) {
            this.renderArmorIcon(guiGraphics, xOffset, 1);
            guiGraphics.m_280488_(this.mc.f_91062_, "" + entity.m_21230_(), xOffset += 10, 2, 0xE0E0E0);
        }
    }

    private void renderArmorIcon(GuiGraphics matrix, int x, int y) {
        matrix.m_280218_(ICON_TEXTURES, x, y, 34, 9, 9, 9);
    }

    private void renderHeartIcon(GuiGraphics matrix, int x, int y) {
        matrix.m_280218_(ICON_TEXTURES, x, y, 52, 0, 9, 9);
    }
}

